/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.humanoid;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class EquippedItemComponent
implements EntityComponent {
    private Entity equippedItem;

    public Entity getEquippedItem() {
        return this.equippedItem;
    }

    public void setEquippedItem(Entity itemToEquip, MessageDispatcher messageDispatcher) {
        this.equippedItem = itemToEquip;
        EntityAttributes attributes = itemToEquip.getPhysicalEntityComponent().getAttributes();
        if (attributes instanceof ItemEntityAttributes) {
            ItemEntityAttributes itemAttributes = (ItemEntityAttributes)attributes;
            itemAttributes.setItemPlacement(ItemPlacement.BEING_CARRIED);
            messageDispatcher.dispatchMessage(null, 324, (Object)itemToEquip);
        }
    }

    public Entity clearEquippedItem() {
        Entity equippedItem = this.equippedItem;
        this.equippedItem = null;
        return equippedItem;
    }

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        EquippedItemComponent clonedComponent = new EquippedItemComponent();
        if (this.equippedItem != null) {
            clonedComponent.setEquippedItem(this.equippedItem.clone(messageDispatcher, tiledMap), messageDispatcher);
        }
        return clonedComponent;
    }
}

